* Analysis of Forecast Accuracy: Sections 2 and 3 of paper
******** Figure 1: An example of a State Price Distribution
use "AllDerivatives.dta", clear
keep if statistic=="rsxaut" & dtrelease==mdy(5,12,2005)
keep probbin* binlb* binub*
gen num=1
reshape long probbin binlb binub, i(num)
rename _j n
rename probbin price

#delimit ;
graph bar (mean) price,
	over(n, gap(10) relabel(1 "<-0.20" 2 "-0.20 to -0.10" 3 "-0.10 to 0.00" 4 "0.00 to 0.10" 5 "0.10 to 0.20" 6 "0.20 to 0.30" 7 "0.30 to 0.40" 8 "0.40 to 0.50" 9 "0.50 to 0.60" 10 "0.60 to 0.70" 11 "0.70 to 0.80" 12 "0.80 to 0.90" 13 "0.90 to 1.00" 14 "1.00 to 1.10" 15 "1.10 to 1.20" 16 "1.20 to 1.30" 17 "1.30 to 1.40" 18 ">1.40") 
	label(labsize(small) angle(forty_five))  )
	blabel(bar) 
	ytitle(Price / Probability) 
	ylabel(, angle(horizontal)) 
	title("An Example: Price of Digital Options") 
	subtitle("Auction on Retail Trade Release for April 2005; Held May 12, 2005")
	xsize(10) ysize(7.5);
#delimit cr
pause

******** Figure 2: Comparing Forecast Performance
use "AllDerivatives.dta", clear
twoway (scatter releasedvalue amean, sort msize(medlarge)) (scatter releasedvalue mmean, msymbol(square_hollow)), by(stat, xrescale yrescale title(Comparing Forecast Performance) legend(position(12))) ylabel(,angle(horizontal)) ytitle(Released Value (Actual)) xtitle(Forecast Value) legend(order(1 "Economic Derivatives Mean Forecast" 2 "Survey: Average Across Forecasters")) legend(position(12)) xsize(10) ysize(7.5)
pause

******** Table 1: Comparing the accuracy of Forecasts
use "AllDerivatives(scaled)", clear

* Panel A: MAE
for any a m: gen Xabserr=abs(Xmeanerr)
for any a m: la var Xabserr "Absolute Error"
for any a m: egen sdXabserr=sd(Xabserr), by(statistic) \ egen nXabserr=count(Xabserr), by(statistic) \ gen seXabserr=sdXabserr/sqrt(nXabserr)
table statistic, c(m aabserr m seaabserr m mabserr m semabserr) format(%9.3f)
for any a m: reg Xabserr
pause

* Panel B: RMSE
for any a m: gen Xsqerr=Xmeanerr*Xmeanerr
for any a m: egen Xmsqerr=mean(Xsqerr), by(statistic)
for any a m: egen sdXsqerr=sd(Xsqerr), by(statistic) \ egen nXsqerr=count(Xsqerr), by(statistic) \ gen seXsqerr=sdXsqerr/sqrt(nXsqerr) \ replace seXsqerr=seXsqerr/sqrt(Xmsqerr)
for any a m: gen Xrmsqerr=(Xmsqerr)^0.5
for any a m: la var Xrmsqerr "Root Mean Squared Error"
for any a m: la var seXsqerr "SE RMSE"
table statistic, c(m armsqerr m seasqerr m mrmsqerr m semsqerr) format(%9.3f)
pause

* Final Column of Panel B
for any a m: egen TXmsqerr=mean(Xsqerr) \ gen rTXmsqerr=sqrt(TXmsqerr) \ egen sdTXmsqerr=sd(Xsqerr) \ egen nTXmsqerr=count(Xsqerr) \ gen seTXmsqerr=(sdTXmsqerr/sqrt(nTXmsqerr))/sqrt(TXmsqerr)
summ rTamsqerr seTamsqerr rTmmsqerr seTmmsqerr
pause

* Panel C: Correlation

bys statistic: pwcorr releasedval amean mmean, sig
pause
for any amean mmean releasedvalue: egen Xmn=mean(X), by(statistic) \ egen Xsd=sd(X), by(statistic) \ gen Xstd=(X-Xmn)/Xsd
reg releasedvaluestd ameanstd, noconst
reg releasedvaluestd mmeanstd, noconst
bys statistic: reg releasedvaluestd ameanstd, noconst
bys statistic: reg releasedvaluestd mmeanstd, noconst
pause

* Panel D: Fair-Shiller
bys statistic: reg releasedvalue amean mmean
xi: reg releasedvalue amean mmean i.statistic
reg releasedvaluestd ameanstd mmeanstd
pause

* Unreported results: Add controls for recent changes in financial variables
bys statistic: reg releasedvalue amean mmean updatesp500 updateonrun_02
xi: reg releasedvalue amean mmean i.statistic*updatesp500 i.statistic*updateonrun_02

******** Figure 3: Financial Market responses
use "AllDerivatives", clear
twoway (scatter sp500 ameanerr, sort msize(medlarge)) (scatter sp500 mmeanerr, msymbol(square_hollow)), by(stat, xrescale title(Equity Market Responses to Economic Statistics) legend(position(12))) ytitle("Change in S&P 500 (%)" "Window: t-5 minutes to t+25 minutes") xtitle(Economic News: Deviation of Announcement from Forecast) legend(size(small) order(1 "Deviation from Economic Derivatives Forecast" 2 "Deviation from Survey Forecast")) legend(position(12)) ylabel(,angle(horizontal)) xsize(10) ysize(7.5)
pause
twoway (scatter onrun10 ameanerr, sort msize(medlarge)) (scatter onrun10 mmeanerr, msymbol(square_hollow)), by(stat, xrescale title(Bond Market Responses to Economic Statistics) legend(position(12))) ytitle("Change in 10-Year Note Yield (basis points)" "Window: t-5 minutes to t+25 minutes") xtitle(Economic News: Deviation of Announcement from Forecast) legend(size(small) order(1 "Deviation from Economic Derivatives Forecast" 2 "Deviation from Survey Forecast")) legend(position(12)) ylabel(,angle(horizontal)) xsize(10) ysize(7.5)
pause

******** Table 2: Financial Market Responses
use "AllDerivatives(scaled)", clear
for var onrun3m-onrun10 sp500: bys statistic: reg X ameanerr mmeanerr
for Y in var onrun3m-onrun10 sp500: xi: reg Y i.statistic*ameanerr i.statistic*mmeanerr \ testparm ameanerr _IstaXamea* \ testparm mmeanerr _IstaXmmea* \ pause

******* Table 3: Tests of Forecast Efficiency
use "AllDerivatives(scaled)", clear

* Panel A: Bias
for any a m: bys statistic: reg Xmeanerr
xi: reg ameanerr i.statistic
testparm *
xi: reg mmeanerr i.statistic
testparm *
pause

* Panel B: Internal efficiency
for any iclm napm nfpay rsxaut: reg ameanerr amean if statistic=="X" \ test _cons amean
xi: reg ameanerr i.statistic*amean
testparm *
for any iclm napm nfpay rsxaut: reg mmeanerr mmean if statistic=="X" \ test _cons mmean
xi: reg mmeanerr i.statistic*mmean
testparm *
pause

* Panel C: Autocorrelation

* Using all adjacent auctions (This is in the paper)
sort statistic dtrelease
for any a m: bys statistic: gen lagallXmeanerr=Xmeanerr[_n-1] \ bys statistic: reg Xmeanerr lagallXmeanerr 
for Y in any a m: xi: reg Ymeanerr i.statistic*lagallYmeanerr \ testparm lagall* _IstaX*

* Using sample only when continuous months occur (unreported)
sort statno time
for any a m: gen lagXmeanerr=l.Xmeanerr
for any a m: bys statistic: reg Xmeanerr lagXmeanerr
xi: reg ameanerr i.statistic*lagameanerr
testparm lagameanerr _IstaX*
xi: reg mmeanerr i.statistic*lagmmeanerr
testparm lagmmeanerr _IstaX*
pause

* Panel D: Information Efficiency
gen slope=sven10ylev-sven3mlev
for any iclm napm nfpay rsxaut: reg ameanerr slope sp500change if statistic=="X" \ test slope sp500
xi: reg ameanerr i.statistic*slope i.statistic*sp500change
testparm slope sp500ch _IstaX*
for any iclm napm nfpay rsxaut: reg mmeanerr slope sp500change if statistic=="X" \ test slope sp500
xi: reg mmeanerr i.statistic*slope i.statistic*sp500change
testparm slope sp500ch _IstaX*
pause

* Panel E: Kitchen Sink
bys statistic: reg ameanerr amean mmean lagallameanerr slope sp500change 
bys statistic: reg mmeanerr amean mmean lagallmmeanerr slope sp500change 
xi: reg ameanerr i.statistic*amean i.statistic*mmean i.statistic*lagallameanerr i.statistic*slope i.statistic*sp500change
xi: reg mmeanerr i.statistic*mmean i.statistic*amean i.statistic*lagallmmeanerr i.statistic*slope i.statistic*sp500change
